-- ANMERKUNG: siehe "Y TWawi.Views.Auftrag.sql"

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Lieferschein__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS Twawi.lieferschein_posext;
        DROP VIEW IF EXISTS TWawi.lieferschein_pos;
    --
    
    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    -- Geht auf den bereits bestehenden public.Lieferschein_pos View zurück, der ebenfalls schreibbar ist. Technisch nur wegen einheitlichem Namensschema für TWawi-Views notwendig.
    -- Zu überlegen wäre, ob der einfach direkt auf die belegpos gehen sollte. 
    CREATE OR REPLACE VIEW TWawi.lieferschein_pos AS
      SELECT
      -- Identifikatoren
        dbrid               AS dbrid                   ,--
        belp_id             AS p_id                    ,-- ID der Pos.
        --                  AS p_dokunr                ,-- Referenz auf das zug. Dokument
        belp_belegtyp       AS p_code                  ,-- Code / Klassifikation / Belegtyp
        --                  AS p_nummer                ,-- Belegnummer
        belp_pos            AS p_pos                   ,-- Positionsnummer
        --                  AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                  AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        belp_aknr           AS p_aknr                  ,-- Artikelnummer
        --                  AS p_aknr_idx              ,-- Artikelindex
        belp_akbez          AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        belp_referenzaknr   AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        belp_menge          AS p_menge                 ,-- Menge in Positions-ME
        belp_mce            AS p_me                    ,-- artmgc.m_id der Positions-ME
        --                  AS p_los                   ,-- Losgröße für Artikel
        belp_menge_gme      AS p_menge_gme             ,-- Menge in GME
        --                  AS p_mengeb_gme            ,-- Menge bestellt in GME
        --                  AS p_mengel_gme            ,-- Menge geliefert in GME
        belp_menge_done_gme AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                  AS p_mengeo                ,-- Offene Menge
        --                  AS p_mengeo_gme            ,-- Offene Menge in GME
        --                  AS p_norm                  ,-- Artikelnorm
        --                  AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                  AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                  AS p_mec                   ,-- ME-Code der Positions-ME
        --                  AS p_gmec                  ,-- ME-Code der Grund-ME
        --                  AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        --                  AS p_preis                 ,-- Preis wie angegeben
        --                  AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht        
        --                  AS p_preis_me              ,-- Preis pro ME        
        --                  AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        --                  AS p_preis_gme             ,-- Preis pro GME
        --                  AS p_preis_gme_gwaer       ,-- Preis pro GME in Grundwährung
        --                  AS p_waer                  ,-- Pos. Währungseinheit
        --                  AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        --                  AS p_scode                 ,-- Steuercode
        --                  AS p_sproz                 ,-- Steuerprozentsatz
        --                  AS p_rabatt                ,-- Rabattsatz (0...100)
        --                  AS p_CanRabatt             ,-- Kennzeichen Rabattfähig
      -- Adressdaten
        --                  AS p_adkrz                 ,-- Adresskürzel (Kunde o. Lieferant)
        --                  AS p_adkrzl                ,-- Adresskürzel Lieferadresse
        --                  AS p_adkrzf                ,-- Adresskürzel Rechnungsadresse
        --                  AS p_apext                 ,-- Kürzel Ansprechpartner extern
        --                  AS p_apextname             ,-- Voller Name Ansprechpartner extern
        --                  AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                  AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        insert_date         AS p_datum_eingang         ,-- Eingangsdatum
        --                  AS p_datum_erfasst         ,-- Erfassdatum
        belp_erstelldatum   AS p_datum_soll            ,-- Wunschdatum
        belp_termin         AS p_datum_ist             ,-- Bestätigtes Datum
        --                  AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum )
        --                  AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                  AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        belp_erledigt       AS p_done                  ,-- Kennzeichen Pos. Erledigt
        belp_storniert      AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                  AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                  AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                  AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        --                  AS p_status                ,-- Allg. Status1
        --                  AS p_status1               ,-- Allg. Status2
        --                  AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        --                  AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                  AS p_vorgaenger_table      ,--
        --                  AS p_vorgaenger_id         ,--
        belp_referenz       AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        --                  AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        belp_projektnummer  AS p_an_nr                 ,-- Projektnummer
        --                  AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        --                  AS p_ab_ix                 ,-- Zugehörige ABK
        --                  AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        --                  AS p_Konto                 ,--
        belp_dokutxt        AS p_txt_ext               ,--
        belp_dokutxt_rtf    AS p_txt_ext_rtf           ,--
        belp_txt            AS p_txt_int               ,--
        belp_txt_rtf        AS p_txt_int_rtf            --
      FROM public.lieferschein_pos; -- ist auch updateable view
    --
    
    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW TWawi.lieferschein_posext AS
      SELECT
      -- Identifikatoren
        pos.dbrid            AS dbrid                     ,--
        p_id                                              ,-- ID der Pos.
        beld_dokunr          AS p_dokunr                  ,-- Referenz auf das zug. Dokument
        p_code                                            ,-- Code / Klassifikation / Belegtyp
        beld_dokunr          AS p_nummer                  ,-- Belegnummer
        p_pos                                             ,-- Positionsnummer
        NULL::INTEGER        AS p_parent                  ,-- Übergeordnete Position (Strukt. Belege)
        'lieferschein_pos'::VARCHAR  AS p_table           ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        p_aknr                                            ,-- Artikelnummer
        COALESCE(ag_aknr_idx, ak_idx) AS p_aknr_idx       ,-- Artikelindex
        COALESCE(p_akbez, ak_bez) AS p_akbez              ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        COALESCE(p_aknr_referenz, ag_aknr_referenz)                                   
                             AS p_aknr_referenz           ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        p_menge                                           ,-- Menge in Positions-ME
        p_me                                              ,-- artmgc.m_id der Positions-ME
        ak_los               AS p_los                     ,-- Losgröße für Artikel
        p_menge_gme                                       ,-- Menge in GME
        NULL::NUMERIC        AS p_mengeb_gme              ,-- Menge bestellt in GME
        NULL::NUMERIC        AS p_mengel_gme              ,-- Menge geliefert in GME
        p_mengef_gme                                      ,-- Menge fakturiert in GME
        tartikel.me__menge_uf1__in__menge(p_me, GREATEST(p_menge_gme-COALESCE(p_mengef_gme, 0), 0)) AS p_mengeo,-- Noch zu bestellende Menge
        GREATEST(p_menge_gme-COALESCE(p_mengef_gme, 0), 0)                     AS p_mengeo_gme,-- Noch zu bestellende Menge in GME
        COALESCE(ag_nident, ak_norm) AS p_norm            ,-- Artikelnorm
        ag_ks                        AS p_ks              ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                      ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                      ,-- ME-Code der Positions-ME
        MEData.p_gmec                                     ,-- ME-Code der Grund-ME
        MEData.p_meuf                                     ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                    ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                   ,-- ISO-Code der Grund-ME
      -- Preisdaten
        ag_preis             AS p_preis                   ,-- Preis wie angegeben
        ag_preiseinheit      AS p_preiseinheit            ,-- Menge auf die sich p_preis bezieht        
        ag_vkp               AS p_preis_me                ,-- Preis pro ME              
        ag_vkp_basis_w       AS p_preis_gwaer             ,-- Preis pro ME in Grundwährung
        ag_vkp_uf1           AS p_preis_gme               ,-- Preis pro GME
        ag_vkp_uf1_basis_w   AS p_preis_gme_gwaer         ,-- Preis pro GME in Grundwährung
        ag_waer              AS p_waer                    ,-- Pos. Währungseinheit
        ag_kurs              AS p_kurs                    ,-- Pos. Kurs zur Basiswährung
        ag_steucode          AS p_scode                   ,-- Steuercode
        ag_ustpr             AS p_sproz                   ,-- Steuerprozentsatz
        ag_arab              AS p_rabatt                  ,-- Rabattsatz (0...100)
        ag_canRabatt         AS p_canRabatt               ,-- Kennzeichen Rabattfähig
        steu_txt             AS p_sbez                    ,-- Steuerbezeichnung
      -- Positionswerte
        p_menge * ag_vkp * (1 - COALESCE(ag_arab, 0) / 100)
                             AS p_wert_netto              ,-- Positionswert, exkl. Steuern, (hier nicht: inkl. AbZuschläge)
        p_menge * ag_vkp * (1 - COALESCE(ag_arab, 0) / 100) * (1 + COALESCE(ag_ustpr, 0) / 100)
                             AS p_wert_brutto             ,-- Positionswert, inkl. Steuern, (hier nicht: inkl. AbZuschläge)
        p_menge * ag_vkp * (1 - COALESCE(ag_arab, 0) / 100) * COALESCE(ag_kurs, 1)
                             AS p_wert_netto_gwaer        ,-- Positionswert, exkl. Steuern, in Grundwährung, (hier nicht: inkl. AbZuschläge)
        p_menge * ag_vkp * (1 - COALESCE(ag_arab, 0) / 100) * (1 + COALESCE(ag_ustpr, 0) / 100) * COALESCE(ag_kurs, 1)
                             AS p_wert_brutto_gwaer       ,-- Positionswert, inkl. Steuern, in Grundwährung, (hier nicht: inkl. AbZuschläge)
      -- Adressdaten
        beld_krzbesteller    AS p_adkrz                   ,-- Adresskürzel (Kunde o. Lieferant)
        beld_krzlieferung    AS p_adkrzl                  ,-- Adresskürzel Lieferadresse
        beld_krzrechnung     AS p_adkrzf                  ,-- Adresskürzel Rechnungsadresse
        beld_apkrzl          AS p_apext                   ,-- Kürzel Ansprechpartner extern
        beld_ap              AS p_apExtName               ,-- Voller Name Ansprechpartner extern
        beld_apint           AS p_apInt                   ,-- Kürzel Ansprechpartner intern
        nameAufloesen(beld_apint) AS p_apintname          ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        p_datum_eingang                                   ,-- Eingangsdatum
        p_datum_eingang      AS p_datum_erfasst           ,-- Erfassdatum
        p_datum_soll                                      ,-- Wunschdatum
        p_datum_ist                                       ,-- Bestätigtes Datum
        COALESCE(p_datum_ist, p_datum_soll) AS p_datum_istsoll,-- Eigentlicher Termin
        NULL::DATE           AS p_datum_storniert         ,-- Datum an dem die Pos. Storniert wurde
        beld_definitiv       AS p_definitiv               ,-- Kennzeichen Pos. Definitiv
        p_done                                            ,-- Kennzeichen Pos. Erledigt
        p_storniert                                       ,-- Kennzeichen Pos. Storniert
        NULL::BOOLEAN        AS p_IsBedarf                ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung         AS p_IsFertigung             ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        NOT ag_nstatistik    AS p_IsUmsatz                ,-- Kennzeichen umsatzwirksame Position
        NULL::VARCHAR        AS p_status                  ,-- Allg. Status1
        NULL::VARCHAR        AS p_status1                 ,-- Allg. Status2
        NULL::VARCHAR        AS p_status2                 ,-- Allg. Status3
      -- Referenzen / Struktur
        ag_rahmen_ag_id      AS p_rahmen_id               ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        'auftg'::VARCHAR     AS p_vorgaenger_table        ,--
        belp_ag_id           AS p_vorgaenger_id           ,--
        p_refnummer                                       ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        NULL::INTEGER       AS p_refpos                   ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        p_an_nr                                           ,-- Projektnummer
        ag_vtp_id           AS p_vtp_id                   ,-- ID der zugehörigen Vertragsposition
        ag_ownabk           AS p_ab_ix                    ,-- Zugehörige ABK
        ag_q_nr             AS p_q_nr                     ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        ag_konto            AS p_konto                    ,-- Kontierung
        p_txt_ext                                         ,-- Positionstext extern
        p_txt_ext_rtf                                     ,--
        p_txt_int                                         ,-- Positionstext intern
        p_txt_int_rtf                                      --
      FROM TWawi.lieferschein_pos AS pos
        JOIN public.lieferschein_pos ON belp_id = p_id
        JOIN public.lieferschein     ON beld_id = belp_dokument_id
        JOIN art                     ON ak_nr   = p_aknr
        LEFT JOIN auftg              ON ag_id   = belp_ag_id
        LEFT JOIN steutxt            ON steu_z  = ag_steucode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr ) AS medata
      ;
    --
    
    
    
    
  END $$ LANGUAGE plpgsql;
--

--SELECT TSystem.views__Wawi_Lieferschein__recreate();
